window.ControlPanelDatabaseGrid = Class.create(Grid, {

    // ---------------------------------------

    mergeModeCookieKey: 'database_tables_merge_mode_cookie_key',
    mergeModeCookieTime: 31536000e3, // 1 year in milliseconds

    // ---------------------------------------

    prepareActions: function()
    {
        this.actions = {
            deleteTableRowsAction: function(id) { this.deleteTableRows(id); }.bind(this),
            updateTableCellsAction: function() { this.openTableCellsPopup('update'); }.bind(this)
        }
    },

    // ---------------------------------------

    switchMergeMode: function()
    {
        this.isMergeModeEnabled() ? this.setMergeMode('0') : this.setMergeMode('1');
        window.location = M2ePro.url.get('adminhtml_controlPanel_database/manageTable');
    },

    isMergeModeEnabled: function()
    {
        var cookieValue = getCookie(this.mergeModeCookieKey);
        return cookieValue != null && cookieValue != '' && cookieValue != '0';
    },

    setMergeMode: function(value)
    {
        setCookie(this.mergeModeCookieKey, value, this.mergeModeCookieTime, '/');
    },

    // ---------------------------------------

    mergeParentTable: function(component)
    {
        this.setMergeMode('1');
        window.location = M2ePro.url.get('adminhtml_controlPanel_database/manageTable', {component: component});
    },

    // ---------------------------------------

    deleteTableRows: function(id)
    {
        var selectedIds = id ? id : ControlPanelDatabaseGridObj.getSelectedProductsString();

        if (id && !confirm('Are you sure?')) {
            return;
        }

        new Ajax.Request(M2ePro.url.get('adminhtml_controlPanel_database/deleteTableRows'), {
            method:'post',
            parameters: {
                ids: selectedIds
            },
            onSuccess: function(transport) {
                ControlPanelDatabaseGridObj.getGridObj().reload()
            }
        });
    },

    openTableCellsPopup: function(mode)
    {
        var self = ControlPanelDatabaseGridObj;

        var popupTitle = mode == 'update' ? 'Edit Table Records' : 'Add Table Row';

        var popup = new Window({
            draggable: true,
            resizable: true,
            closable: true,
            className: "magento",
            windowClassName: "popup-window",
            title: popupTitle,
            top: 50,
            width: 635,
            minHeight: 200,
            maxHeight: 445,
            zIndex: 100,
            destroyOnClose: true,
            recenterAuto: true,
            hideEffect: Element.hide,
            showEffect: Element.show
        });

        new Ajax.Request(M2ePro.url.get('adminhtml_controlPanel_database/getTableCellsPopupHtml'), {
            method: 'post',
            parameters: {
                ids: self.getSelectedProductsString(),
                mode: mode
            },
            onSuccess: function(transport) {
                popup.getContent().insert(transport.responseText);
            }
        });

        popup.showCenter(true);
    },

    confirmUpdateCells: function()
    {
        if (!ControlPanelDatabaseGridObj.isAnySwitcherEnabled()) {
            alert('You should select columns.');
            return;
        }

        new Ajax.Request(M2ePro.url.get('adminhtml_controlPanel_database/updateTableCells'), {
            method: 'post',
            asynchronous: false,
            parameters: Form.serialize($('controlPanel_tabs_database_table_cells_popup_form')),
            onSuccess: function(transport) {
                ControlPanelDatabaseGridObj.unselectAllAndReload();
                Windows.getFocusedWindow().close();
            }
        });
    },

    confirmAddRow: function()
    {
        if (!ControlPanelDatabaseGridObj.isAnySwitcherEnabled()) {
            alert('You should select columns.');
            return;
        }

        new Ajax.Request(M2ePro.url.get('adminhtml_controlPanel_database/addTableRow'), {
            method: 'post',
            asynchronous: false,
            parameters: Form.serialize($('controlPanel_tabs_database_table_cells_popup_form')),
            onSuccess: function(transport) {
                ControlPanelDatabaseGridObj.getGridObj().reload();
                Windows.getFocusedWindow().close();
            }
        });
    },

    // ---------------------------------------

    mouseOverCell: function(cellId)
    {
        if ($(cellId + '_save_link').getStyle('display') != 'none') {
            return;
        }

        $(cellId + '_edit_link').show();
        $(cellId + '_view_link').hide();
        $(cellId + '_save_link').hide();
    },

    mouseOutCell: function(cellId)
    {
        if ($(cellId + '_save_link').getStyle('display') != 'none') {
            return;
        }

        $(cellId + '_edit_link').hide();
        $(cellId + '_view_link').hide();
        $(cellId + '_save_link').hide();
    },

    // ---------------------------------------

    switchCellToView: function(cellId)
    {
        $(cellId + '_edit_link').show();
        $(cellId + '_view_link').hide();
        $(cellId + '_save_link').hide();

        $(cellId + '_edit_container').hide();
        $(cellId + '_view_container').show();
    },

    switchCellToEdit: function(cellId)
    {
        $(cellId + '_edit_link').hide();
        $(cellId + '_view_link').show();
        $(cellId + '_save_link').show();

        $(cellId + '_edit_container').show();
        $(cellId + '_view_container').hide();
    },

    saveTableCell: function(rowId, columnName)
    {
        var params = {
            ids: rowId,
            cells: columnName
        };

        var cellId = 'table_row_cell_' + columnName + '_' + rowId;
        params['value_'+ columnName] = $(cellId + '_edit_input').value;

        new Ajax.Request(M2ePro.url.get('adminhtml_controlPanel_database/updateTableCells'), {
            method: 'post',
            asynchronous: false,
            parameters: params,
            onSuccess: function(transport) {
                ControlPanelDatabaseGridObj.switchCellToView(cellId);
                ControlPanelDatabaseGridObj.getGridObj().reload();
            }
        });
    },

    onKeyDownEdit: function(rowId, columnName, event)
    {
        if (event.keyCode != 13) {
            return false;
        }

        ControlPanelDatabaseGridObj.saveTableCell(rowId, columnName);
        return false;
    },

    // ---------------------------------------

    switcherStateChange: function()
    {
        var inputElement = $(this.id.replace('switcher','input'));

        inputElement.removeAttribute('disabled');

        if (!this.checked) {
            inputElement.value = '';
            inputElement.setAttribute('disabled', 'disabled');
        }
    },

    isAnySwitcherEnabled: function()
    {
        var result = false;

        $$('#controlPanel_tabs_database_table_cells_popup .input_switcher').each(function(el) {
            if (el.checked) {
                result = true;
                return true;
            }
        });

        return result;
    }

    // ---------------------------------------
});