<?php

/*
 * @author     M2E Pro Developers Team
 * @copyright  M2E LTD
 * @license    Commercial use is forbidden
 */

class Ess_M2ePro_Adminhtml_Amazon_GeneralController
    extends Ess_M2ePro_Controller_Adminhtml_Amazon_MainController
{
    //########################################

    protected function _initAction()
    {
        $this->loadLayout()
            ->_title(Mage::helper('M2ePro')->__('Configuration'))
            ->_title(Mage::helper('M2ePro')->__('General'));

        $this->getLayout()
             ->getBlock('head')
             ->addJs('M2ePro/Amazon/Configuration.js');

        $this->_initPopUp();

        $this->setPageHelpLink(null, null, "configurations");

        return $this;
    }

    protected function _isAllowed()
    {
        return Mage::getSingleton('admin/session')->isLoggedIn();
    }

    //########################################

    public function indexAction()
    {
        if (!Mage::helper('M2ePro/Component_Amazon')->isEnabled()) {
            $this->_redirect('*/adminhtml_amazon_synchronization/index');
        }

        $this->_initAction()
            ->_addContent(
                $this->getLayout()->createBlock(
                    'M2ePro/adminhtml_amazon_configuration', '',
                    array('active_tab' => Ess_M2ePro_Block_Adminhtml_Amazon_Configuration_Tabs::TAB_ID_GENERAL)
                )
            )->renderLayout();
    }

    //########################################
}
