<?php

/*
 * @author     M2E Pro Developers Team
 * @copyright  M2E LTD
 * @license    Commercial use is forbidden
 */

abstract class Ess_M2ePro_Model_Walmart_Listing_Product_Variation_Manager_Type_Relation_Parent_Processor_Sub_Abstract
{
    /** @var Ess_M2ePro_Model_Walmart_Listing_Product_Variation_Manager_Type_Relation_Parent_Processor $_processor  */
    protected $_processor = null;

    //########################################

    public function getProcessor()
    {
        return $this->_processor;
    }

    public function setProcessor($processor)
    {
        $this->_processor = $processor;
        return $this;
    }

    //########################################

    public function process()
    {
        $this->validate();

        $this->check();
        $this->execute();
    }

    //########################################

    protected function validate()
    {
        if ($this->getProcessor() === null) {
            throw new Ess_M2ePro_Model_Exception_Logic('Processor was not set.');
        }
    }

    // ---------------------------------------

    abstract protected function check();

    abstract protected function execute();

    //########################################
}
