<?php

/*
 * @author     M2E Pro Developers Team
 * @copyright  M2E LTD
 * @license    Commercial use is forbidden
 */

use Ess_M2ePro_Model_Walmart_Listing_Product_Action_Type_Revise_Request as ReviseRequest;

class Ess_M2ePro_Model_Walmart_Listing_Product_Action_Type_Revise_Response
    extends Ess_M2ePro_Model_Walmart_Listing_Product_Action_Type_Response
{
    //########################################

    /**
     * @param array $params
     */
    public function processSuccess($params = array())
    {
        $data = array();

        if ($this->getRequestData()->getIsNeedProductIdUpdate()) {
            $data['wpid'] = $params['wpid'];
        }

        if ($this->getConfigurator()->isPriceAllowed()) {
            $data['is_online_price_invalid'] = 0;
        }

        $data = $this->appendStatusChangerValue($data);
        $data = $this->appendQtyValues($data);
        $data = $this->appendLagTimeValues($data);
        $data = $this->appendPriceValues($data);
        $data = $this->appendPromotionsValues($data);
        $data = $this->appendDetailsValues($data);
        $data = $this->appendStartDate($data);
        $data = $this->appendEndDate($data);
        $data = $this->appendChangedSku($data);
        $data = $this->appendProductIdsData($data);
        $data = $this->appendIsStoppedManually($data, false);

        $this->getListingProduct()->addData($data);

        $this->setLastSynchronizationDates();

        $this->getListingProduct()->save();
    }

    //########################################
}
