<?php

/*
 * @author     M2E Pro Developers Team
 * @copyright  M2E LTD
 * @license    Commercial use is forbidden
 */

class Ess_M2ePro_Helper_View_ControlPanel_Command extends Mage_Core_Helper_Abstract
{
    //########################################

    const CONTROLLER_MODULE_INTEGRATION         = 'adminhtml_controlPanel_module_integration';
    const CONTROLLER_MODULE_INTEGRATION_EBAY    = 'adminhtml_controlPanel_module_integration_ebay';
    const CONTROLLER_MODULE_INTEGRATION_AMAZON  = 'adminhtml_controlPanel_module_integration_amazon';
    const CONTROLLER_MODULE_INTEGRATION_WALMART = 'adminhtml_controlPanel_module_integration_walmart';

    const CONTROLLER_TOOLS_M2EPRO_GENERAL   = 'adminhtml_controlPanel_tools_m2ePro_general';
    const CONTROLLER_TOOLS_M2EPRO_INSTALL   = 'adminhtml_controlPanel_tools_m2ePro_install';
    const CONTROLLER_TOOLS_MAGENTO          = 'adminhtml_controlPanel_tools_magento';
    const CONTROLLER_TOOLS_ADDITIONAL       = 'adminhtml_controlPanel_tools_additional';

    //########################################

    public function parseGeneralCommandsData($controller)
    {
        $tempClass = Mage::helper('M2ePro/View_ControlPanel_Controller')->loadControllerAndGetClassName($controller);

        $reflectionClass = new ReflectionClass($tempClass);
        $reflectionMethods = $reflectionClass->getMethods(ReflectionMethod::IS_PUBLIC);

        // Get actions methods
        // ---------------------------------------
        $actions = array();
        foreach ($reflectionMethods as $reflectionMethod) {
            $className = $reflectionClass->getMethod($reflectionMethod->name)
                                         ->getDeclaringClass()->name;
            $methodName = $reflectionMethod->name;

            if (substr($className, 0, 10) != 'Ess_M2ePro') {
                continue;
            }

            if ($methodName == 'indexAction') {
                continue;
            }

            if (substr($methodName, strlen($methodName)-6) != 'Action') {
                continue;
            }

            $methodName = substr($methodName, 0, strlen($methodName)-6);

            $actions[] = $methodName;
        }

        // ---------------------------------------

        // Print method actions
        // ---------------------------------------
        $methods = array();
        foreach ($actions as $action) {
            $controllerName = Mage::helper('M2ePro/View_ControlPanel_Controller')->getControllerClassName($controller);
            $reflectionMethod = new ReflectionMethod($controllerName, $action.'Action');

            $commentsString = $this->getMethodComments($reflectionMethod);

            preg_match('/@hidden/', $commentsString, $matches);
            if (isset($matches[0])) {
                continue;
            }

            $methodInvisible = false;
            preg_match('/@invisible/', $commentsString, $matches);
            isset($matches[0]) && $methodInvisible = true;

            $methodTitle = $action;
            preg_match('/@title[\s]*\"(.*)\"/', $commentsString, $matches);
            isset($matches[1]) && $methodTitle = $matches[1];

            $methodDescription = '';
            preg_match('/@description[\s]*\"(.*)\"/', $commentsString, $matches);
            isset($matches[1]) && $methodDescription = $matches[1];

            $methodContent = '';
            $fileContent = file($reflectionMethod->getFileName());
            for ($i = $reflectionMethod->getStartLine() + 2; $i < $reflectionMethod->getEndLine(); $i++) {
                $methodContent .= $fileContent[$i-1];
            }

            $methodNewLine = false;
            preg_match('/@new_line/', $commentsString, $matches);
            isset($matches[0]) && $methodNewLine = true;

            $methodConfirm = false;
            preg_match('/@confirm[\s]*\"(.*)\"/', $commentsString, $matches);
            isset($matches[1]) && $methodConfirm = $matches[1];

            $methodPrompt = false;
            preg_match('/@prompt[\s]*\"(.*)\"/', $commentsString, $matches);
            isset($matches[1]) && $methodPrompt = $matches[1];

            $methodPromptVar = '';
            preg_match('/@prompt_var[\s]*\"(.*)\"/', $commentsString, $matches);
            isset($matches[1]) && $methodPromptVar = $matches[1];

            $methodNewWindow = false;
            preg_match('/new_window/', $commentsString, $matches);
            isset($matches[0]) && $methodNewWindow = true;

            $methods[] = array(
                'invisible'      => $methodInvisible,
                'title'          => $methodTitle,
                'description'    => $methodDescription,
                'url'            => Mage::helper('adminhtml')->getUrl('*/' . $controller . '/' . $action),
                'content'        => $methodContent,
                'new_line'       => $methodNewLine,
                'confirm'        => $methodConfirm,
                'prompt'      => array(
                    'text' => $methodPrompt,
                    'var'  => $methodPromptVar
                ),
                'new_window'  => $methodNewWindow
            );
        }

        // ---------------------------------------

        return $methods;
    }

    //########################################

    protected function getMethodComments(ReflectionMethod $reflectionMethod)
    {
        $contentPhpFile = file_get_contents($reflectionMethod->getFileName());
        $contentPhpFile = explode(chr(10), $contentPhpFile);

        $commentsArray = array();
        for ($i=$reflectionMethod->getStartLine()-2;$i>0;$i--) {
            $contentPhpFile[$i] = trim($contentPhpFile[$i]);
            $commentsArray[] = $contentPhpFile[$i];
            if ($contentPhpFile[$i] == '/**' ||
                $contentPhpFile[$i] == '}') {
                break;
            }
        }

        $commentsArray = array_reverse($commentsArray);
        $commentsString = implode(chr(10), $commentsArray);

        return $commentsString;
    }

    //########################################
}
