<?php

/*
 * @author     M2E Pro Developers Team
 * @copyright  M2E LTD
 * @license    Commercial use is forbidden
 */

class Ess_M2ePro_Block_Adminhtml_Walmart_Listing_Product_Add_SourceMode_Form extends Mage_Adminhtml_Block_Widget_Form
{
    //########################################

    public function __construct()
    {
        parent::__construct();

        $this->setId('listingSourceMode');
        $this->setTemplate('M2ePro/walmart/listing/product/add/source_mode.phtml');
    }

    protected function _prepareForm()
    {
        $form = new Varien_Data_Form(
            array(
            'id'      => 'edit_form',
            'action'  => $this->getUrl('*/*/*'),
            'method'  => 'post',
            'enctype' => 'multipart/form-data'
            )
        );

        $form->setUseContainer(true);
        $this->setForm($form);

        return parent::_prepareForm();
    }

    protected function _beforeToHtml()
    {
        $this->setData(
            'source',
            $this->getRequest()->getParam('source', Ess_M2ePro_Model_Listing::SOURCE_PRODUCTS_CUSTOM)
        );

        return parent::_beforeToHtml();
    }

    //########################################
}
