<?php

/*
 * @author     M2E Pro Developers Team
 * @copyright  M2E LTD
 * @license    Commercial use is forbidden
 */

class Ess_M2ePro_Block_Adminhtml_Ebay_Template_Description_Edit_Form_Data extends Mage_Adminhtml_Block_Widget
{
    protected $_attributeSets = array();

    public $attributes = array();
    public $M2eProAttributes = array();
    public $attributesConfigurable = array();

    //########################################

    public function __construct()
    {
        parent::__construct();

        // Initialization block
        // ---------------------------------------
        $this->setId('ebayTemplateDescriptionEditFormData');
        // ---------------------------------------

        $this->setTemplate('M2ePro/ebay/template/description/form/data.phtml');

        $this->_attributeSets = Mage::helper('M2ePro/Data_Global')->getValue('ebay_attribute_sets');
        $this->attributes = Mage::helper('M2ePro/Magento_Attribute')->getAll();
        $this->attributesConfigurable = Mage::helper('M2ePro/Magento_Attribute')->getAllConfigurable();

        $this->M2eProAttributes = array(
            'title' => Mage::helper('M2ePro')->__('Title'),
            'subtitle' => Mage::helper('M2ePro')->__('Subtitle'),
            'condition' => Mage::helper('M2ePro')->__('Condition'),
            'condition_description' => Mage::helper('M2ePro')->__('Seller Notes'),
            'fixed_price' => Mage::helper('M2ePro')->__('Fixed Price'),
            'start_price' => Mage::helper('M2ePro')->__('Start Price'),
            'reserve_price' => Mage::helper('M2ePro')->__('Reserve Price'),
            'buyitnow_price' => Mage::helper('M2ePro')->__('Buy It Now Price'),
            'qty' => Mage::helper('M2ePro')->__('QTY'),
            'main_image' => Mage::helper('M2ePro')->__('Base Image Url'),
            'gallery_image[1]' => Mage::helper('M2ePro')->__('Gallery Image URL 1'),
            'gallery_image[2]' => Mage::helper('M2ePro')->__('Gallery Image URL 2'),
            'gallery_image[3]' => Mage::helper('M2ePro')->__('Gallery Image URL 3'),
            'gallery_image[4]' => Mage::helper('M2ePro')->__('Gallery Image URL 4'),
            'gallery_image[5]' => Mage::helper('M2ePro')->__('Gallery Image URL 5'),
            'gallery_image[6]' => Mage::helper('M2ePro')->__('Gallery Image URL 6'),
            'gallery_image[7]' => Mage::helper('M2ePro')->__('Gallery Image URL 7'),
            'gallery_image[8]' => Mage::helper('M2ePro')->__('Gallery Image URL 8'),
            'gallery_image[9]' => Mage::helper('M2ePro')->__('Gallery Image URL 9'),
            'gallery_image[10]' => Mage::helper('M2ePro')->__('Gallery Image URL 10'),
            'gallery_image[11]' => Mage::helper('M2ePro')->__('Gallery Image URL 11'),
            'listing_type' => Mage::helper('M2ePro')->__('Listing Type'),
            'listing_duration' => Mage::helper('M2ePro')->__('Listing Duration'),
            'handling_time' => Mage::helper('M2ePro')->__('Dispatch Time'),
            'primary_category_id' => Mage::helper('M2ePro')->__('Primary Category Id'),
            'secondary_category_id' => Mage::helper('M2ePro')->__('Secondary Category Id'),
            'store_primary_category_id' => Mage::helper('M2ePro')->__('Store Primary Category Id'),
            'store_secondary_category_id' => Mage::helper('M2ePro')->__('Store Secondary Category Id'),
            'primary_category_name' => Mage::helper('M2ePro')->__('Primary Category Name'),
            'secondary_category_name' => Mage::helper('M2ePro')->__('Secondary Category Name'),
            'store_primary_category_name' => Mage::helper('M2ePro')->__('Store Primary Category Name'),
            'store_secondary_category_name' => Mage::helper('M2ePro')->__('Store Secondary Category Name'),
            'domestic_shipping_method[1]' => Mage::helper('M2ePro')->__('Domestic Shipping First Method'),
            'domestic_shipping_cost[1]' => Mage::helper('M2ePro')->__('Domestic Shipping First Cost'),
            'domestic_shipping_additional_cost[1]' =>
                                            Mage::helper('M2ePro')->__('Domestic Shipping First Additional Cost'),
            'international_shipping_method[1]' => Mage::helper('M2ePro')->__('International Shipping First Method'),
            'international_shipping_cost[1]' => Mage::helper('M2ePro')->__('International Shipping First Cost'),
            'international_shipping_additional_cost[1]' =>
                                            Mage::helper('M2ePro')->__('International Shipping First Additional Cost'),
        );
    }

    protected function _beforeToHtml()
    {
        // ---------------------------------------
        $buttonBlock = $this->getLayout()
            ->createBlock('adminhtml/widget_button')
            ->setData(
                array(
                'label'   => Mage::helper('M2ePro')->__('Insert'),
                'onclick' => 'EbayTemplateDescriptionObj.openInsertImageWindow();',
                'class' => 'insert_image_window_button'
                )
            );
        $this->setChild('insert_image_window_button', $buttonBlock);
        // ---------------------------------------

        // ---------------------------------------
        $buttonBlock = $this->getLayout()
            ->createBlock('adminhtml/widget_button')
            ->setData(
                array(
                'label'   => Mage::helper('M2ePro')->__('Insert'),
                'onclick' => "AttributeObj.appendToText"
                ."('select_attributes_for_subtitle', 'subtitle_template');",
                'class' => 'add_subtitle_button'
                )
            );
        $this->setChild('add_subtitle_button', $buttonBlock);
        // ---------------------------------------

        // ---------------------------------------
        $buttonBlock = $this->getLayout()
            ->createBlock('adminhtml/widget_button')
            ->setData(
                array(
                'label' => Mage::helper('M2ePro')->__('Insert'),
                'onclick' => "AttributeObj.appendToText"
                ."('select_attributes_for_title', 'title_template');",
                'class' => 'select_attributes_for_title_button'
                )
            );
        $this->setChild('select_attributes_for_title_button', $buttonBlock);
        // ---------------------------------------

        // ---------------------------------------
        $buttonBlock = $this->getLayout()
            ->createBlock('adminhtml/widget_button')
            ->setData(
                array(
                'label'   => Mage::helper('M2ePro')->__('Insert'),
                'onclick' => "AttributeObj.appendToText"
                ."('select_attributes_for_condition_note', 'condition_note_template');",
                'class' => 'add_condition_note_button'
                )
            );
        $this->setChild('add_condition_note_button', $buttonBlock);
        // ---------------------------------------

        // ---------------------------------------
        $buttonBlock = $this->getLayout()
            ->createBlock('adminhtml/widget_button')
            ->setData(
                array(
                'id' => 'toggletext',
                'label' => Mage::helper('M2ePro')->__('Show / Hide Editor'),
                'class' => 'show_hide_mce_button',
                )
            );
        $this->setChild('show_hide_mce_button', $buttonBlock);
        // ---------------------------------------

        // ---------------------------------------
        $buttonBlock = $this->getLayout()
            ->createBlock('adminhtml/widget_button')
            ->setData(
                array(
                'label'   => Mage::helper('M2ePro')->__('Insert'),
                'onclick' => "AttributeObj.appendToTextarea('#' + $('select_attributes').value + '#');",
                'class'   => 'add_product_attribute_button',
                )
            );
        $this->setChild('add_product_attribute_button', $buttonBlock);
        // ---------------------------------------

        // ---------------------------------------
        $buttonBlock = $this->getLayout()
            ->createBlock('adminhtml/widget_button')
            ->setData(
                array(
                'label'   => Mage::helper('M2ePro')->__('Insert'),
                'onclick' => "AttributeObj.appendToTextarea"
                ."('#value[' + $('select_m2epro_attributes').value + ']#');",
                'class' => 'add_product_attribute_button',
                )
            );
        $this->setChild('add_m2epro_attribute_button', $buttonBlock);
        // ---------------------------------------

        // ---------------------------------------
        $buttonBlock = $this->getLayout()
            ->createBlock('adminhtml/widget_button')
            ->setData(
                array(
                'label'   => Mage::helper('M2ePro')->__('Insert'),
                'onclick' => 'EbayTemplateDescriptionObj.insertGallery();',
                'class' => 'insert_gallery_button',
                )
            );
        $this->setChild('insert_gallery_button', $buttonBlock);
        // ---------------------------------------

        // ---------------------------------------

        $buttonBlock = $this->getLayout()
         ->createBlock('adminhtml/widget_button')
        ->setData(
            array(
                'label'   => Mage::helper('M2ePro')->__('Preview'),
                'onclick' => 'EbayTemplateDescriptionObj.preview_click(\''
                             .implode(',', $this->_attributeSets) . '\')',
                'class' => 'bt_preview',
            )
        );
        $this->setChild('preview_button', $buttonBlock);
        // ---------------------------------------

        return parent::_beforeToHtml();
    }

    //########################################

    public function isCustom()
    {
        if (isset($this->_data['is_custom'])) {
            return (bool)$this->_data['is_custom'];
        }

        return false;
    }

    public function isEdit()
    {
        $template = Mage::helper('M2ePro/Data_Global')->getValue('ebay_template_description');

        if ($template === null || $template->getId() === null) {
            return false;
        }

        return true;
    }

    //########################################

    public function getTitle()
    {
        if ($this->isCustom()) {
            return isset($this->_data['custom_title']) ? $this->_data['custom_title'] : '';
        }

        if (!$this->isEdit()) {
            return '';
        }

        $template = Mage::helper('M2ePro/Data_Global')->getValue('ebay_template_description');

        return $template->getTitle();
    }

    //########################################

    public function getFormData()
    {
        if (!$this->isEdit()) {
            return array();
        }

        $template = Mage::helper('M2ePro/Data_Global')->getValue('ebay_template_description');
        $data = $template->getData();

        if (!empty($data['enhancement']) && is_string($data['enhancement'])) {
            $data['enhancement'] = explode(',', $data['enhancement']);
        } else {
            unset($data['enhancement']);
        }

        if (!empty($data['product_details']) && is_string($data['product_details'])) {
            $data['product_details'] = Mage::helper('M2ePro')->jsonDecode($data['product_details']);
        } else {
            unset($data['product_details']);
        }

        if (!empty($data['variation_configurable_images']) && is_string($data['variation_configurable_images'])) {
            $data['variation_configurable_images'] = Mage::helper('M2ePro')->jsonDecode(
                $data['variation_configurable_images']
            );
        } else {
            unset($data['variation_configurable_images']);
        }

        if (!empty($data['watermark_settings']) && is_string($data['watermark_settings'])) {
            $watermarkSettings = Mage::helper('M2ePro')->jsonDecode($data['watermark_settings']);
            unset($data['watermark_settings']);

            if (isset($watermarkSettings['position'])) {
                $data['watermark_settings']['position'] = $watermarkSettings['position'];
            }

            if (isset($watermarkSettings['scale'])) {
                $data['watermark_settings']['scale'] = $watermarkSettings['scale'];
            }

            if (isset($watermarkSettings['transparent'])) {
                $data['watermark_settings']['transparent'] = $watermarkSettings['transparent'];
            }

            if (isset($watermarkSettings['hashes']['current'])) {
                $data['watermark_settings']['hashes']['current'] = $watermarkSettings['hashes']['current'];
            }

            if (isset($watermarkSettings['hashes']['previous'])) {
                $data['watermark_settings']['hashes']['previous'] = $watermarkSettings['hashes']['previous'];
            }
        } else {
            unset($data['watermark_settings']);
        }

        return $data;
    }

    //########################################

    public function getDefault()
    {
        $default = Mage::getModel('M2ePro/Ebay_Template_Description_Builder')->getDefaultData();

        $helper = Mage::helper('M2ePro');

        $default['enhancement'] = explode(',', $default['enhancement']);
        $default['product_details'] = $helper->jsonDecode($default['product_details']);
        $default['variation_configurable_images'] = $helper->jsonDecode($default['variation_configurable_images']);
        $default['watermark_settings'] = $helper->jsonDecode($default['watermark_settings']);

        return $default;
    }

    //########################################
}
