<?php

/*
 * @author     M2E Pro Developers Team
 * @copyright  M2E LTD
 * @license    Commercial use is forbidden
 */

class Ess_M2ePro_Block_Adminhtml_ControlPanel_Tabs_Database_Table_TableCellsPopup extends Mage_Adminhtml_Block_Widget
{
    const MODE_CREATE = 'create';
    const MODE_UPDATE = 'update';

    protected $_mode = self::MODE_UPDATE;

    public $tableName;
    public $modelName;
    public $component;

    public $mergeMode;

    public $rowsIds = array();

    //########################################

    public function __construct()
    {
        parent::__construct();

        // Initialization block
        // ---------------------------------------
        $this->setId('controlPanelDatabaseTableCellsPopup');
        // ---------------------------------------

        $this->_mode = $this->getRequest()->getParam('mode');

        $this->tableName = $this->getRequest()->getParam('table');
        $this->modelName = $this->getRequest()->getParam('model');
        $this->component = $this->getRequest()->getParam('component');

        $this->mergeMode = (bool)$this->getRequest()->getParam('merge', false);

        $this->rowsIds = explode(',', $this->getRequest()->getParam('ids'));

        $this->setTemplate('M2ePro/controlPanel/tabs/database/table_cells_popup.phtml');
    }

    //########################################

    protected function _toHtml()
    {
        // ---------------------------------------
        $data = array(
            'id'      => 'controlPanel_database_update_cell_popup_confirm_button',
            'label'   => Mage::helper('M2ePro')->__('Confirm'),
            'onclick' => 'ControlPanelDatabaseGridObj.confirmUpdateCells();',
        );
        $buttonBlock = $this->getLayout()->createBlock('adminhtml/widget_button')->setData($data);
        $this->setChild('popup_confirm_update_button', $buttonBlock);
        // ---------------------------------------

        // ---------------------------------------
        $data = array(
            'id'      => 'controlPanel_database_add_cell_popup_confirm_button',
            'label'   => Mage::helper('M2ePro')->__('Confirm'),
            'onclick' => 'ControlPanelDatabaseGridObj.confirmAddRow();',
        );
        $buttonBlock = $this->getLayout()->createBlock('adminhtml/widget_button')->setData($data);
        $this->setChild('popup_confirm_add_button', $buttonBlock);
        // ---------------------------------------

        return parent::_toHtml();
    }

    //########################################

    public function getTableColumns()
    {
        $table = Mage::getModel("M2ePro/{$this->modelName}")->getResource()->getMainTable();
        $columns = Mage::helper('M2ePro/Module_Database_Structure')->getTableInfo($table);

        if ($this->ifNeedToUseMergeMode()) {
            array_walk(
                $columns, function(&$el) {
                $el['is_parent'] = true; 
                }
            );

            $modelName = 'M2ePro/'.ucfirst($this->component).'_'.$this->modelName;
            $table = Mage::getModel($modelName)->getResource()->getMainTable();

            $childColumns = Mage::helper('M2ePro/Module_Database_Structure')->getTableInfo($table);
            array_walk(
                $childColumns, function(&$el) {
                $el['is_parent'] = false; 
                }
            );

            $columns = array_merge($columns, $childColumns);
        }

        return $columns;
    }

    public function isUpdateCellsMode()
    {
        return $this->_mode == self::MODE_UPDATE;
    }

    public function ifNeedToUseMergeMode()
    {
        return $this->mergeMode &&
               Mage::helper('M2ePro/Module_Database_Structure')->isTableHorizontal($this->tableName);
    }

    //########################################
}
