Configuration = Class.create();
Configuration.prototype = {

    urls: {},

    // ---------------------------------------

    initialize: function()
    {
        var cmdKeys = [67, 79, 78, 84, 82, 79, 76, 80, 65, 78, 69, 76];
        var cmdPressedKeys = [];

        document.observe('keyup', function(event) {

            if (cmdPressedKeys.length < cmdKeys.length) {
                if (cmdKeys[cmdPressedKeys.length] == event.keyCode) {
                    cmdPressedKeys.push(event.keyCode);
                } else {
                    cmdPressedKeys = [];
                }
            }

            if (cmdPressedKeys.length == cmdKeys.length) {

                $('row_installation_upgrade_settings_m2ePro_minimum_stability').show();
                $('row_installation_upgrade_settings_updater_minimum_stability').show();
                cmdPressedKeys = [];
            }
        });
    },

    // ---------------------------------------

    showModuleChangelogPopup: function(module)
    {
        new Ajax.Request(this.urls['adminhtml_configuration/getChangeLogHtml'], {
            method: 'post',
            asynchronous: true,
            parameters: {
                module: module
            },
            onSuccess: function(transport) {

                var popupObj = Dialog.info(null, {
                    draggable: true,
                    resizable: true,
                    closable: true,
                    className: "magento",
                    windowClassName: "popup-window",
                    title: 'Changelog',
                    top: 50,
                    height: 300,
                    width: 560,
                    zIndex: 100,
                    hideEffect: Element.hide,
                    showEffect: Element.show
                });

                popupObj.options.destroyOnClose = true;

                $('modal_dialog_message').insert(transport.responseText);
                $('modal_dialog_message').innerHTML.evalScripts();

                this.autoHeightFix();
            }.bind(this)
        });
    },

    showSchedulePopup: function(title)
    {
        var popupObj = Dialog.info(null, {
            draggable: true,
            resizable: true,
            closable: true,
            className: "magento",
            windowClassName: "popup-window",
            title: title,
            top: 50,
            height: 300,
            width: 560,
            zIndex: 100,
            hideEffect: Element.hide,
            showEffect: Element.show
        });

        popupObj.options.destroyOnClose = false;
        $('modal_dialog_message').insert($('m2epro_updater_schedule_upgrade_popup_content').show());
        $('modal_dialog_message').innerHTML.evalScripts();

        this.autoHeightFix();
    },

    schedule: function()
    {
        window.location = this.urls['adminhtml_configuration/schedule'];
    },

    decline: function()
    {
        window.location = this.urls['adminhtml_configuration/decline'];
    },

    autoHeightFix: function()
    {
        setTimeout(function() {
            Windows.getFocusedWindow().content.style.height = '';
            Windows.getFocusedWindow().content.style.maxHeight = '650px';
        }, 150);
    }

    // ---------------------------------------
};