<?php

/*
 * @author     M2E Pro Developers Team
 * @copyright  2011-2016 ESS-UA [M2E Pro]
 * @license    Commercial use is forbidden
 */

class Ess_M2eProUpdater_Block_Adminhtml_System_Message extends Ess_M2eProUpdater_Block_Abstract
{
    //########################################

    public function _toHtml()
    {
        if (!$this->isDisplayed()) {
            return '';
        }

        $link = $this->getUrl('adminhtml/system_config/edit', array(
            'section' => Ess_M2eProUpdater_Observer_Configuration::INSTALLATION_UPGRADE_SECTION
        ));

        return <<<HTML
<div class="notification-global">
    A new version of M2E Pro is available. Navigate System > Configuration > M2E Pro > Upgrade to
    schedule an upgrade.
    Click <a target="_blank" href="{$link}">here</a> to get to the Upgrade page now.
</div>
HTML;
    }

    //########################################

    private function isDisplayed()
    {
        /** @var Mage_Adminhtml_Model_Session $session */
        $session = Mage::getSingleton('admin/session');
        if (!$session->isLoggedIn()) {
            return false;
        }

        /** @var Ess_M2eProUpdater_Helper_Config $helper */
        $helper = Mage::helper('M2eProUpdater/Config');
        if (!$helper->isNotificationMagentoSystemNotification()) {
            return false;
        }

        /** @var Ess_M2eProUpdater_Helper_M2ePro $helper */
        $helper = Mage::helper('M2eProUpdater/M2ePro');

        if (!$helper->getCurrentVersion() ||
            version_compare($helper->getCurrentVersion(), $helper->getLatestAvailableVersion(), '>=')
        ) {
            return false;
        }

        return true;
    }

    //########################################
}