<?php

/*
 * @author     M2E Pro Developers Team
 * @copyright  2011-2016 ESS-UA [M2E Pro]
 * @license    Commercial use is forbidden
 */

class Ess_M2eProUpdater_Block_Adminhtml_Configuration_Messages
    extends Ess_M2eProUpdater_Block_Abstract
    implements Varien_Data_Form_Element_Renderer_Interface
{
    //########################################

    public function render(Varien_Data_Form_Element_Abstract $element)
    {
        return $this->_toHtml();
    }

    //########################################

    protected function _toHtml()
    {
        /** @var Ess_M2eProUpdater_Block_Adminhtml_Messages $messagesBlock */
        $messagesBlock = $this->getLayout()->createBlock('M2eProUpdater/adminhtml_messages');

        $this->addCronMessages($messagesBlock);
        $this->addLatestUpgradeWasFailedMessage($messagesBlock);
        $this->addScheduleMessage($messagesBlock);

        return $messagesBlock->toHtml();
    }

    //########################################

    private function addCronMessages(Ess_M2eProUpdater_Block_Adminhtml_Messages $messagesBlock)
    {
        /** @var Ess_M2eProUpdater_Helper_Support $supportHelper */
        $supportHelper = Mage::helper('M2eProUpdater/Support');

        if (!Mage::helper('M2eProUpdater/Cron')->isInstalled()) {

            $url = $supportHelper->getDocumentationUrl(null, 'x/BQA9AQ');
            $url .= '#viaM2EProInstallation/UpgradeModule-SetupInstallation\UpgradeModule';

            $message = <<<HTML
Attention! Cron file m2epro_updater_cron.php has not worked for more than an hour.
Make sure you complete all the steps of <a target="_blank" href="{$url}">set-up instructions</a>
for M2E Pro Updater.
HTML;
            $messagesBlock->addError($supportHelper->__($message));
            return;
        }

        if (Mage::helper('M2eProUpdater/Cron')->isLastRunMoreThan(1, true)) {

            $url = $supportHelper->getDocumentationUrl(null, 'x/BQA9AQ');
            $url .= '#viaM2EProInstallation/UpgradeModule-SetupInstallation\UpgradeModule';

            $message = <<<HTML
Attention! Cron file m2epro_updater_cron.php has not worked for more than an hour.
Make sure you complete all the steps of <a target="_blank" href="{$url}">set-up instructions</a>
for M2E Pro Updater.
HTML;
            $messagesBlock->addWarning($supportHelper->__($message));
        }
    }

    private function addLatestUpgradeWasFailedMessage(Ess_M2eProUpdater_Block_Adminhtml_Messages $messagesBlock)
    {
        if ($this->isLatestUpgradeWasCompletedUnsuccessfully()) {

            $fileName = $this->getLatestUpgradeLogFileName();
            $downloadUrl = $this->getUrl('adminhtml/m2eProUpdater_log/get', array('file_name' => $fileName));
            $removeUrl   = $this->getUrl('adminhtml/m2eProUpdater_log/remove', array('file_name' => $fileName));

            $message = <<<HTML
Failed to install/upgrade M2E Pro. View <a href="{$downloadUrl}">logs</a> for the details.
Click <a href="{$removeUrl}">here</a> to ignore this message. 
HTML;
            $messagesBlock->addError(Mage::helper('M2eProUpdater')->__($message));
        }
    }

    private function addScheduleMessage(Ess_M2eProUpdater_Block_Adminhtml_Messages $messagesBlock)
    {
        /** @var Ess_M2eProUpdater_Helper_Config $configHelper */
        $configHelper = Mage::helper('M2eProUpdater/Config');
        if (!$configHelper->isUpgradeAllowed()) {
            return;
        }

        $message = Mage::helper('M2eProUpdater/M2ePro')->isInstalled()
            ? Mage::helper('M2eProUpdater')->__('M2E Pro will be upgraded shortly. Please wait.')
            : Mage::helper('M2eProUpdater')->__('M2E Pro will be installed shortly. Please wait.');

        $messagesBlock->addNotice($message);
    }

    //########################################

    private function isLatestUpgradeWasCompletedUnsuccessfully()
    {
        /** @var Ess_M2eProUpdater_Helper_Module $moduleHelper */
        $moduleHelper = Mage::helper('M2eProUpdater/Module');
        $filePath = $moduleHelper->getLogDirectoryPath() .DS. $this->getLatestUpgradeLogFileName();

        if (!is_file($filePath) || trim(file_get_contents($filePath)) == '') {
            return false;
        }

        return true;
    }

    private function getLatestUpgradeLogFileName()
    {
        /** @var Ess_M2eProUpdater_Helper_M2ePro $m2eProHelper */
        $m2eProHelper = Mage::helper('M2eProUpdater/M2ePro');
        $latestVersion = $m2eProHelper->getLatestAvailableVersion();

        $fileName = Ess_M2eProUpdater_Model_Cron_Task_DoUpgrade::LOG_FILE_NAME_MASK;
        $latestVersion && $fileName = str_replace('%ver%', $latestVersion, $fileName);

        return $fileName;
    }

    //########################################
}