<?php

/*
 * @author     M2E Pro Developers Team
 * @copyright  2011-2016 ESS-UA [M2E Pro]
 * @license    Commercial use is forbidden
 */

class Ess_M2eProUpdater_Block_Adminhtml_Configuration_Field_Information_UpdaterLatestVersion
    extends Ess_M2eProUpdater_Block_Adminhtml_Configuration_Field_Abstract
{
    //########################################

    protected function _getElementHtml(Varien_Data_Form_Element_Abstract $element)
    {
        /** @var Ess_M2eProUpdater_Helper_Module $helper */
        $helper = Mage::helper('M2eProUpdater/Module');

        $currentVersion = $helper->getCurrentVersion();
        $latestVersion  = $helper->getLatestAvailableVersion();

        if ($latestVersion && (version_compare($latestVersion, $currentVersion, '>'))) {

            $latestVersion .= '  ' .$helper->__('[New]');

            $url = Mage::helper('M2eProUpdater/Support')->getDocumentationUrl(null, 'x/BQA9AQ');
            $url .= '#viaM2EProUpdater-Set-up';

            $afterHtml = <<<HTML
<a href="{$url}" target="_blank">{$helper->__('[upgrade instructions]')}</a>
HTML;

            $element->setBold(true);
            $element->setData('after_element_html', $afterHtml);

        } else if (!$latestVersion) {
            $latestVersion = $helper->__('N/A');
        }

        $element->setValue($latestVersion);
        return parent::_getElementHtml($element);
    }

    //########################################
}