<?php

/*
 * @author     M2E Pro Developers Team
 * @copyright  2011-2016 ESS-UA [M2E Pro]
 * @license    Commercial use is forbidden
 */

class Ess_M2eProUpdater_Block_Adminhtml_Configuration_Field_AutomaticUpgrade_ScheduleUpgrade
    extends Ess_M2eProUpdater_Block_Adminhtml_Configuration_Field_Abstract
{
    //########################################

    protected function _prepareLayout()
    {
        parent::_prepareLayout();
        $this->initPopup();
    }

    protected function _getElementHtml(Varien_Data_Form_Element_Abstract $element)
    {
        $element->setScopeLabel(false);
        $helper = Mage::helper('M2eProUpdater/M2ePro');

        $popupTitle  = $helper->__('Confirm M2E Pro Installation');
        $buttonTitle = $helper->__('Schedule Installation');

        if ($helper->isInstalled()) {
            $popupTitle  = $helper->__('Confirm M2E Pro Upgrade');
            $buttonTitle = $helper->__('Schedule Upgrade');
        }

        $button = $this->getLayout()->createBlock('adminhtml/widget_button');
        $button->setData(
            array(
                'id'      => 'schedule_upgrade_button',
                'label'   => $buttonTitle,
                'class'   => 'primary',
                'onclick' => "ConfigurationObj.showSchedulePopup('{$popupTitle}')",
            )
        );

        return $this->getPopupHtml() . $button->toHtml();
    }

    public function render(Varien_Data_Form_Element_Abstract $element)
    {
        if (!$this->isVisible()) {
            return '';
        }

        return parent::render($element);
    }

    //########################################

    private function isVisible()
    {
        /** @var Ess_M2eProUpdater_Helper_Config $configHelper */
        $configHelper = Mage::helper('M2eProUpdater/Config');

        if ($configHelper->isUpgradeAllowed()) {
            return false;
        }

        /** @var Ess_M2eProUpdater_Helper_M2ePro $m2eProHelper */
        $m2eProHelper = Mage::helper('M2eProUpdater/M2ePro');

        $currentVersion = $m2eProHelper->getCurrentVersion();
        $latestVersion  = $m2eProHelper->getLatestAvailableVersion();

        if ($latestVersion && version_compare($latestVersion, $currentVersion, '>')) {
            return true;
        }

        return false;
    }

    private function getPopupHtml()
    {
        $helper = Mage::helper('M2eProUpdater/M2ePro');

        $confirmButton = $this->getLayout()->createBlock('adminhtml/widget_button');
        $confirmButton->setData(
            array(
                'id'      => 'schedule_upgrade_button',
                'label'   => $helper->__('Confirm'),
                'class'   => 'primary',
                'onclick' => "ConfigurationObj.schedule()",
            )
        );

        $title = $helper->isInstalled() ? 'upgrade' : 'installation';

        $url = Mage::helper('M2eProUpdater/Support')->getDocumentationUrl(null, 'x/BQA9AQ');
        $url .= $helper->isInstalled() ? '#viaM2EProUpdater-M2EProUpgrade' : '#viaM2EProUpdater-M2EProInstallation';

        $jsUrls = json_encode(
            array(
                'adminhtml_configuration/schedule' => $this->getUrl(
                    'adminhtml/m2eProUpdater_configuration/save',
                    array(
                        'path'  => base64_encode(Ess_M2eProUpdater_Helper_Config::UPGRADE_ALLOWED_PATH),
                        'value' => base64_encode('1')
                    )
                ),
            )
        );

        return <<<HTML
<script type="text/javascript">
    Object.extend(ConfigurationObj.urls, {$jsUrls});
</script>

<div id="m2epro_updater_schedule_upgrade_popup_content" style="display: none;">

    <p style="padding: 10px;">
        It can take up to 15 minutes to prepare the system for an update.
        Your Magento instance will stay in maintenance mode until the Extension {$title} is finished.<br><br>

        Please ensure that all the <a href="{$url}" target="_blank">preliminary requirements</a>
        for the installation are met before you confirm the action.
    </p>

    <div style="text-align: right; margin-bottom: 10px;">
        <a href="javascript:" onclick="Windows.getFocusedWindow().close();">{$helper->__('Cancel')}</a>
        &nbsp;&nbsp;&nbsp;&nbsp;
        {$confirmButton->toHtml()}
    </div>
</div>
HTML;
    }

    //########################################
}