<?php

/*
 * @author     M2E Pro Developers Team
 * @copyright  2011-2016 ESS-UA [M2E Pro]
 * @license    Commercial use is forbidden
 */

class Ess_M2eProUpdater_Block_Adminhtml_Configuration_Field_AutomaticUpgrade_DeclineUpgrade
    extends Ess_M2eProUpdater_Block_Adminhtml_Configuration_Field_Abstract
{
    //########################################

    public function render(Varien_Data_Form_Element_Abstract $element)
    {
        if (!$this->isVisible()) {
            return '';
        }

        return parent::render($element);
    }

    protected function _getElementHtml(Varien_Data_Form_Element_Abstract $element)
    {
        $element->setScopeLabel(false);
        $helper = Mage::helper('M2eProUpdater/M2ePro');

        $jsUrls = json_encode(
            array(
                'adminhtml_configuration/decline' => $this->getUrl(
                    'adminhtml/m2eProUpdater_configuration/save',
                    array(
                        'path'  => base64_encode(Ess_M2eProUpdater_Helper_Config::UPGRADE_ALLOWED_PATH),
                        'value' => base64_encode('0')
                    )
                ),
            )
        );

        $button = $this->getLayout()->createBlock('adminhtml/widget_button');
        $button->setData(
            array(
                'id'      => 'decline_upgrade_button',
                'label'   => $helper->isInstalled()
                    ? $helper->__('Cancel Upgrade')
                    : $helper->__('Cancel Installation'),
                'class'   => 'primary',
                'onclick' => "ConfigurationObj.decline()",
            )
        );

        return <<<HTML
<script type="text/javascript" style="display: none;">
    Object.extend(ConfigurationObj.urls, {$jsUrls});
</script>
HTML
               . $button->toHtml();
    }

    //########################################

    private function isVisible()
    {
        /** @var Ess_M2eProUpdater_Helper_Config $configHelper */
        $configHelper = Mage::helper('M2eProUpdater/Config');
        return $configHelper->isUpgradeAllowed();
    }

    //########################################
}